# to autoload this file
proc m2Utils.tcl {} {}


#================================================================================
#  Utilities providing convenience, e.g. DEF opening from MOD etc.  #
#================================================================================

namespace eval M2 {}


#===============================================================================
# Idea from Raymond Waldrop <rwaldrop@cs.tamu.edu> and Juan Falgueras, author
# of Mod2 mode
#===============================================================================
# The following will switch between the definition and implementation module
# assuming they're in the same directory and file names differ only in extensions. 
# However, actual code of idea generating proc Mod2otherPart has been completely 
# rewritten.
proc otherLibModule {} {
    set curname "[win::Current]"

	set path "[file dirname $curname]:"
	set extension [file extension $curname]
	set tgtBaseName [file rootname [file tail $curname]]
	set tgtName ""
	if       {"$extension" == ".MOD"} then { 
		set tgtName "$tgtBaseName.DEF" 
	} elseif {"$extension" == ".mod"} then { 
		set tgtName "$tgtBaseName.def" 
	} elseif {"$extension" == ".DEF"} then { 
		set tgtName "$tgtBaseName.MOD" 
	} elseif {"$extension" == ".def"} then { 
		set tgtName "$tgtBaseName.mod" 
	} else {
		message "Current file has not a proper extension of form .DEF, .def, .MOD, or .mod"
	}
	# check if path contains MOD or DEF according to dir naming
	# conventions on DEV server e.g. if $path == pathBegin:Base.MOD
	# then allow for search in pathBegin:Base.DEF or vice versa
    set pathAlt "[file dirname $curname]"
	if {[file extension $pathAlt] == ".MOD"} then {
		set pathAlt "[file root $pathAlt].DEF:"
	} elseif {[file extension $pathAlt] == ".DEF"} then {
		set pathAlt "[file root $pathAlt].MOD:"
	} else {
		set pathAlt ""
	}
	return [list $path $tgtName $pathAlt]
}

proc openOtherLibModule {} {
	set otherLibModPFN [otherLibModule]
	set path [lindex $otherLibModPFN 0]
	set tgtName [lindex $otherLibModPFN 1]
	set pathAlt [lindex $otherLibModPFN 2]
	if {("$tgtName" != "")} then {
		if {([file exists "$path$tgtName"])} then {
			message "Found module '$tgtName' in directory '$path'"
			win::OpenQuietly "$path$tgtName"
		} elseif {([file exists "$pathAlt$tgtName"])} then {
			message "Found module '$tgtName' in directory '$pathAlt'"
			win::OpenQuietly "$pathAlt$tgtName"
		} else {
			message "Module '$tgtName' not in directory '$path'"
		}
	}
}

proc M2::OptionTitlebar {} {
	set otherLibModPFN [otherLibModule]
	set path [lindex $otherLibModPFN 0]
	set tgtName [lindex $otherLibModPFN 1]
	return "$tgtName"
}





# Reporting that end of this script has been reached
message "m2Utils.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
	alertnote "m2Utils.tcl for Programing in Modula-2 loaded"
}
